void Enc_ExcludeNation(ref rEnc, int iNation)
{
	string sNation = Nations[iNation].Name;
	rEnc.Nation.Exclude.(sNation) = true;
}

void Enc_AddShips(ref rEnc, string sEType, int iShipsMin, int iShipsMax)
{
	rEnc.(sEType).ShipsMin = iShipsMin;		
	rEnc.(sEType).ShipsMax = iShipsMax;
}

void Enc_AddClasses(ref rEnc, int iRank, int iMClassMin, int iMClassMax, int iWClassMin, int iWClassMax)
{
	string sRank = "Rank." + iRank;
	rEnc.(sRank).0 = iMClassMin; rEnc.(sRank).1 = iMClassMax;
	rEnc.(sRank).2 = iWClassMin; rEnc.(sRank).3 = iWClassMax;
}

void InitEncounters()
{
	int i;
	ref rEnc;

	for (i=0; i<MAX_ENCOUNTER_TYPES; i++)
	{
		makeref(rEnc, EncountersTypes[i]);
		rEnc.Index = i;
		rEnc.Chance = 100;
		rEnc.Skip = false;
		rEnc.MinRank = 1;
		rEnc.MaxRank = 1000;
		rEnc.Merchant.ShipsMin = 0;		rEnc.Merchant.ShipsMax = 0;
		rEnc.War.ShipsMin = 0;			rEnc.War.ShipsMax = 0;
		rEnc.Type = ENCOUNTER_TRADE;
	}
	////  boal    ,     3
    	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_ALONE]);
 	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.Chance = 0;
	rEnc.Skip   = true;
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 1-2  5-6 .
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_SMALL]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MinRank = 1;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "sloop";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
	Enc_AddShips(rEnc, "Merchant", 1, 2);
	Enc_AddClasses(rEnc, 1, 4, 7, 0, 0);
	Enc_AddClasses(rEnc, 1000,4, 7, 0, 0);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	Enc_AddShips(rEnc, "Merchant", 1, 1);
	Enc_AddClasses(rEnc, 1, 5, 7, 0, 0);
	Enc_AddClasses(rEnc, 1000,5, 7, 0, 0);
	}

	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-4  5-6 .
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_MEDIUM]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "bark";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 18;
	Enc_AddShips(rEnc, "Merchant", 2, 4);
	Enc_AddClasses(rEnc, 20, 4, 6, 0, 0);
	Enc_AddClasses(rEnc, 1000,4, 6, 0, 0);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 3;
	Enc_AddShips(rEnc, "Merchant", 1, 2);
	Enc_AddClasses(rEnc, 8, 4, 7, 0, 0);
	Enc_AddClasses(rEnc, 1000,4, 7, 0, 0);
	}

	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-5  4-6 .
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_LARGE]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "galleon";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 28;
	Enc_AddShips(rEnc, "Merchant", 3, 5);
	Enc_AddClasses(rEnc, 30, 3, 6, 0, 0);
	Enc_AddClasses(rEnc, 1000,3, 6, 0, 0);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 5;
	Enc_AddShips(rEnc, "Merchant", 1, 3);
	Enc_AddClasses(rEnc, 15, 3, 7, 0, 0);
	Enc_AddClasses(rEnc, 1000,3, 7, 0, 0);
	}
		
	///////////////////////////////////////////////////////////////////////////////////////
	/// 1-3  5-6   1  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_GUARD_SMALL]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MinRank = 1;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "sloop";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
	Enc_AddShips(rEnc, "Merchant", 1, 3);
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 1, 4, 6, 4, 5);
	Enc_AddClasses(rEnc, 1000,4, 6, 4, 5);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	Enc_AddShips(rEnc, "Merchant", 1, 1);
	Enc_AddShips(rEnc, "War", 1, 1);
	Enc_AddClasses(rEnc, 1, 5, 7, 5, 7);
	Enc_AddClasses(rEnc, 1000,5, 7, 5, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-3  5-6   1-2  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_GUARD_MEDIUM]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "bark";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 9;
	Enc_AddShips(rEnc, "Merchant", 2, 3);
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 20, 3, 6, 2, 5);
	Enc_AddClasses(rEnc, 1000,3, 6, 2, 5);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 3;
	Enc_AddShips(rEnc, "Merchant", 1, 2);
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 8, 4, 7, 4, 7);
	Enc_AddClasses(rEnc, 1000,4, 7, 4, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-5  4-6   1-2  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_MERCHANT_GUARD_LARGE]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "galleon";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 15;
	Enc_AddShips(rEnc, "Merchant", 3, 5);
	Enc_AddShips(rEnc, "War", 2, 3);
	Enc_AddClasses(rEnc, 30, 2, 6, 1, 5);
	Enc_AddClasses(rEnc, 1000,2, 6, 1, 5);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 5;
	Enc_AddShips(rEnc, "Merchant", 1, 3);
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 15, 3, 7, 3, 7);
	Enc_AddClasses(rEnc, 1000,3, 7, 3, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-3  3-4   1-2  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_ESCORT_SMALL]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "bark";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 1;
	Enc_AddShips(rEnc, "Merchant", 2, 3);
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 1, 3, 4, 3, 4);
	Enc_AddClasses(rEnc, 1000,3, 4, 3, 4);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 5;
	Enc_AddShips(rEnc, "Merchant", 1, 1);
	Enc_AddShips(rEnc, "War", 1, 1);
	Enc_AddClasses(rEnc, 1, 5, 7, 5, 7);
	Enc_AddClasses(rEnc, 1000,5, 7, 5, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-4  3-4   2-3  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_ESCORT_MEDIUM]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "galleon";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 9;
	Enc_AddShips(rEnc, "Merchant", 2, 4);
	Enc_AddShips(rEnc, "War", 2, 3);
	Enc_AddClasses(rEnc, 20, 3, 4, 2, 4);
	Enc_AddClasses(rEnc, 1000,3, 4, 2, 4);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 7;
	Enc_AddShips(rEnc, "Merchant", 1, 2);
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 8, 4, 7, 4, 7);
	Enc_AddClasses(rEnc, 1000,4, 7, 4, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-5  3-4   2-4  
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_ESCORT_LARGE]);
	rEnc.Type = ENCOUNTER_TRADE;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "manowar";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 15;
	Enc_AddShips(rEnc, "Merchant", 3, 5);
	Enc_AddShips(rEnc, "War", 2, 4);
	Enc_AddClasses(rEnc, 30, 3, 4, 1, 3);
	Enc_AddClasses(rEnc, 1000,3, 4, 1, 3);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "Merchant", 1, 3);
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 15, 3, 7, 3, 7);
	Enc_AddClasses(rEnc, 1000,3, 7, 3, 7);
	}

	// ======================== WAR ENCOUNTERS ========================

	///////////////////////////////////////////////////////////////////////////////////////
	/// 1-2   4-6 
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PATROL_SMALL]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MinRank = 1;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "bark";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 1, 0, 0, 3, 5);
	Enc_AddClasses(rEnc, 1000,0, 0, 3, 5);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	Enc_AddShips(rEnc, "War", 1, 1);
	Enc_AddClasses(rEnc, 1, 0, 0, 5, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 5, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-4   3-5 
	///////////////////////////////////////////////////////////////////////////////////////

	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PATROL_MEDIUM]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "frigate";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "War", 2, 4);
	Enc_AddClasses(rEnc, 20, 0, 0, 2, 5);
	Enc_AddClasses(rEnc, 1000,0, 0, 2, 5);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 7;
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 8, 0, 0, 4, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 4, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-5   3-4 
	/////////////////////////////////////////////////////////////////////////////////////// 
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PATROL_LARGE]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "frigate";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 18;
	Enc_AddShips(rEnc, "War", 3, 5);
	Enc_AddClasses(rEnc, 30, 0, 0, 2, 4);
	Enc_AddClasses(rEnc, 1000,0, 0, 2, 4);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 15, 0, 0, 3, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 3, 7);
	}
		
	///////////////////////////////////////////////////////////////////////////////////////
	/// 1-2 
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PIRATE_SMALL]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MinRank = 1;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "sloop";
	Enc_ExcludeNation(rEnc, ENGLAND);
	Enc_ExcludeNation(rEnc, FRANCE);
	Enc_ExcludeNation(rEnc, SPAIN);
	Enc_ExcludeNation(rEnc, HOLLAND);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 1, 0, 0, 4, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 4, 7);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	Enc_AddShips(rEnc, "War", 1, 1);
	Enc_AddClasses(rEnc, 1, 0, 0, 5, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 5, 7);
	}

	///////////////////////////////////////////////////////////////////////////////////////
	/// 1-4 
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PIRATE_MEDIUM]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "sloop";
	Enc_ExcludeNation(rEnc, ENGLAND);
	Enc_ExcludeNation(rEnc, FRANCE);
	Enc_ExcludeNation(rEnc, SPAIN);
	Enc_ExcludeNation(rEnc, HOLLAND);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 9;
		Enc_AddShips(rEnc, "War", 1, 4);
	Enc_AddClasses(rEnc, 15, 0, 0, 3, 6);
	Enc_AddClasses(rEnc, 1000,0, 0, 3, 6);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 5;
	Enc_AddShips(rEnc, "War", 1, 2);
	Enc_AddClasses(rEnc, 10, 0, 0, 4, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 4, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-6 
	///////////////////////////////////////////////////////////////////////////////////////
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PIRATE_LARGE]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.Chance = 30;
	rEnc.worldMapShip = "bark";
	Enc_ExcludeNation(rEnc, ENGLAND);
	Enc_ExcludeNation(rEnc, FRANCE);
	Enc_ExcludeNation(rEnc, SPAIN);
	Enc_ExcludeNation(rEnc, HOLLAND);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 14;
		Enc_AddShips(rEnc, "War", 2, 6);
	Enc_AddClasses(rEnc, 25, 0, 0, 2, 6);
	Enc_AddClasses(rEnc, 1000,0, 0, 2, 6);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "War", 1, 3);
		Enc_AddClasses(rEnc, 15, 0, 0, 3, 7);
		Enc_AddClasses(rEnc, 1000,0, 0, 3, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-3   3-4 
	/////////////////////////////////////////////////////////////////////////////////////// 
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_SQUADRON]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.worldMapShip = "frigate";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 15;
	Enc_AddShips(rEnc, "War", 2, 3);
	Enc_AddClasses(rEnc, 8, 0, 0, 1, 4);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 4);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 7;
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 3, 0, 0, 3, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 3, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-5   2-4 
	/////////////////////////////////////////////////////////////////////////////////////// 
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_FLEET]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.Chance = 30;
	rEnc.worldMapShip = "manowar";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 36;
	Enc_AddShips(rEnc, "War", 3, 5);
	Enc_AddClasses(rEnc, 18, 0, 0, 1, 4);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 4);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "War", 1, 5);
	Enc_AddClasses(rEnc, 8, 0, 0, 1, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 3-7   1-3 
	/////////////////////////////////////////////////////////////////////////////////////// 
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_ARMADA]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.Chance = 30;
	rEnc.worldMapShip = "manowar";;
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 53;
	Enc_AddShips(rEnc, "War", 3, 7);
	Enc_AddClasses(rEnc, 48, 0, 0, 1, 3);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 3);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 15;
	Enc_AddShips(rEnc, "War", 1, 5);
	Enc_AddClasses(rEnc, 26, 0, 0, 1, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 7);
	}
	
	///////////////////////////////////////////////////////////////////////////////////////
	/// 2-4   1-3 
	/////////////////////////////////////////////////////////////////////////////////////// 
	makeref(rEnc, EncountersTypes[ENCOUNTER_TYPE_PUNITIVE_SQUADRON]);
	rEnc.Type = ENCOUNTER_WAR;
	rEnc.MaxRank = 1000;
	rEnc.Chance = 30;
	rEnc.worldMapShip = "manowar";
	Enc_ExcludeNation(rEnc, PIRATE);

	if(!REALISTIC_SHIP_ENCOUNTERS) // = If Realistic Ship Encounters is NOT enabled
	{
		rEnc.MinRank = 24;
	Enc_AddShips(rEnc, "War", 2, 4);
	Enc_AddClasses(rEnc, 8, 0, 0, 1, 3);
	Enc_AddClasses(rEnc, 1000,0, 0, 1, 3);

	}
       		else // = If Realistic Ship Encounters IS enabled
		{
	rEnc.MinRank = 10;
	Enc_AddShips(rEnc, "War", 1, 3);
	Enc_AddClasses(rEnc, 1, 0, 0, 3, 7);
	Enc_AddClasses(rEnc, 1000,0, 0, 3, 7);	
	}
		
	Trace("Init encounters complete.");
}